import 'package:photogram_admin_cp/ui/components/layout.dart';
import 'package:rad/rad.dart';
import 'package:rad/widgets_html.dart';

import 'package:photogram_admin_cp/import/core.dart';

import 'package:photogram_admin_cp/ui/pages/common/form_editor_page.dart';

class AutoFeedTweaking extends StatefulWidget {
  const AutoFeedTweaking({Key? key}) : super(key: key);

  @override
  _AutoFeedTweakingState createState() => _AutoFeedTweakingState();
}

class _AutoFeedTweakingState extends State<AutoFeedTweaking> with AppActiveContentMixin {
  @override
  build(context) {
    return PageRow(
      children: [
        Division(
          className: 'col-lg-6',
          child: FormEditorPage(
            heading: 'Auto Feed Tweaking',
            description: 'Feed tweaks enables more engagement between end users of your site.',
            items: [
              SettingItem(
                intId: AppSettings.ID_SS_BOOL_IMPLICIT_HASHTAG_FOLLOW_ON_POST_LIKE,
                settingKey: AppSettings.KEY_SS_BOOL_IMPLICIT_HASHTAG_FOLLOW_ON_POST_LIKE,
                type: FieldType.switchable,
                leading: 'Follow hashtags on Post liked',
                description: 'Follow post hashtags which user gave a like.',
              ),
              SettingItem(
                intId: AppSettings.ID_SS_BOOL_IMPLICIT_HASHTAG_FOLLOW_ON_POST_COMMENT,
                settingKey: AppSettings.KEY_SS_BOOL_IMPLICIT_HASHTAG_FOLLOW_ON_POST_COMMENT,
                type: FieldType.switchable,
                leading: 'Follow hashtags on Post Comment',
                description: 'Follow post hashtags on which user made a comment.',
              ),
              SettingItem(
                intId: AppSettings.ID_SS_BOOL_IMPLICIT_HASHTAG_FOLLOW_ON_POST_COMMENT_REPLY,
                settingKey: AppSettings.KEY_SS_BOOL_IMPLICIT_HASHTAG_FOLLOW_ON_POST_COMMENT_REPLY,
                type: FieldType.switchable,
                leading: 'Follow hashtags on Reply to Post Comment',
                description: 'Follow post hashtags on which user made a reply to someones comment.',
              ),
            ],
          ),
        ),
      ],
    );
  }
}
